/*
 * Copyright (c) 2005, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package com.sun.java.util.jar.pack;

import java.util.ListResourceBundle;

public class DriverResource_zh_CN extends ListResourceBundle {

    public static final String VERSION = "VERSION";
    public static final String BAD_ARGUMENT = "BAD_ARGUMENT";
    public static final String BAD_OPTION = "BAD_OPTION";
    public static final String BAD_REPACK_OUTPUT = "BAD_REPACK_OUTPUT";
    public static final String DETECTED_ZIP_COMMENT = "DETECTED_ZIP_COMMENT";
    public static final String SKIP_FOR_REPACKED = "SKIP_FOR_REPACKED";
    public static final String WRITE_PACK_FILE = "WRITE_PACK_FILE";
    public static final String WRITE_PACKGZ_FILE = "WRITE_PACKGZ_FILE";
    public static final String SKIP_FOR_MOVE_FAILED = "SKIP_FOR_MOVE_FAILED";
    public static final String PACK_HELP = "PACK_HELP";
    public static final String UNPACK_HELP = "UNPACK_HELP";
    public static final String MORE_INFO = "MORE_INFO";
    public static final String DUPLICATE_OPTION = "DUPLICATE_OPTION";
    public static final String BAD_SPEC = "BAD_SPEC";
    public static final String DEPRECATED = "DEPRECATED";

    /*
     * The following are the output of 'pack200' and 'unpack200' commands.
     * Do not translate command arguments and words with a prefix of '-' or '--'.
     */
    private static final Object[][] resource = {
        {VERSION, "{0}\u7248\u672C {1}"}, // parameter 0:class name;parameter 1: version value
        {BAD_ARGUMENT, "\u9519\u8BEF\u53C2\u6570: {0}"},
        {BAD_OPTION, "\u9519\u8BEF\u9009\u9879: {0}={1}"}, // parameter 0:option name;parameter 1:option value
        {BAD_REPACK_OUTPUT, "--repack \u8F93\u51FA\u9519\u8BEF: {0}"}, // parameter 0:filename
        {DETECTED_ZIP_COMMENT, "\u68C0\u6D4B\u5230 ZIP \u6CE8\u91CA: {0}"}, // parameter 0:comment
        {SKIP_FOR_REPACKED, "\u7531\u4E8E\u5DF2\u91CD\u65B0\u6253\u5305\u800C\u8DF3\u8FC7: {0}"}, // parameter 0:filename
        {WRITE_PACK_FILE, "\u8981\u5199\u5165 *.pack \u6587\u4EF6, \u8BF7\u6307\u5B9A --no-gzip: {0}"}, // parameter 0:filename
        {WRITE_PACKGZ_FILE, "\u8981\u5199\u5165 *.pack.gz \u6587\u4EF6, \u8BF7\u6307\u5B9A --gzip: {0}"}, // parameter 0:filename
        {SKIP_FOR_MOVE_FAILED, "\u7531\u4E8E\u79FB\u52A8\u5931\u8D25\u800C\u8DF3\u8FC7\u89E3\u5305: {0}"}, // parameter 0:filename
        {PACK_HELP, new String[] {
                "\u7528\u6CD5:  pack200 [-opt... | --option=value]... x.pack[.gz] y.jar",
                "",
                "\u6253\u5305\u9009\u9879",
                "  -r, --repack                    \u518D\u6B21\u6253\u5305\u6216\u89C4\u8303\u5316 jar, \u9002\u5408\u4E8E ",
                "                                  \u4F7F\u7528 jarsigner \u8FDB\u884C\u7B7E\u540D",
                "  -g, --no-gzip                   \u8F93\u51FA\u65E0\u683C\u5F0F\u7684\u5305\u6587\u4EF6, \u9002\u5408\u4E8E",
                "                                  \u4F7F\u7528\u6587\u4EF6\u538B\u7F29\u5B9E\u7528\u7A0B\u5E8F\u8FDB\u884C\u538B\u7F29",
                "  --gzip                          (\u9ED8\u8BA4\u503C) \u4F7F\u7528 gzip \u5BF9\u5305\u8F93\u51FA\u8FDB\u884C",
                "                                  \u538B\u7F29\u540E\u5904\u7406",
                "  -G, --strip-debug               \u6253\u5305\u65F6\u5220\u9664\u8C03\u8BD5\u5C5E\u6027 (SourceFile,",
                "                                  LineNumberTable, LocalVariableTable",
                "                                  \u548C LocalVariableTypeTable)",
                "  -O, --no-keep-file-order        \u4E0D\u4F20\u8F93\u6587\u4EF6\u6392\u5E8F\u4FE1\u606F",
                "  --keep-file-order               (\u9ED8\u8BA4\u503C) \u4FDD\u7559\u8F93\u5165\u6587\u4EF6\u6392\u5E8F",
                "  -S{N}, --segment-limit={N}      \u9650\u5236\u6BB5\u5927\u5C0F (\u9ED8\u8BA4\u4E3A\u65E0\u9650\u5236)",
                "  -E{N}, --effort={N}             \u6253\u5305\u6548\u679C (\u9ED8\u8BA4\u503C N=5)",
                "  -H{h}, --deflate-hint={h}       \u4F20\u8F93\u538B\u7F29\u63D0\u793A: true, false",
                "                                   \u6216 keep (\u9ED8\u8BA4\u503C)",
                "  -m{V}, --modification-time={V}  \u4F20\u8F93 modtimes: latest \u6216 keep (\u9ED8\u8BA4\u503C)",
                "  -P{F}, --pass-file={F}          \u4F20\u8F93\u672A\u66F4\u6539\u7684\u7ED9\u5B9A\u8F93\u5165\u5143\u7D20",
                "  -U{a}, --unknown-attribute={a}  \u672A\u77E5\u5C5E\u6027\u64CD\u4F5C: error, strip",
                "                                  \u6216 pass (\u9ED8\u8BA4\u503C)",
                "  -C{N}={L}, --class-attribute={N}={L}  (\u7528\u6237\u5B9A\u4E49\u7684\u5C5E\u6027)",
                "  -F{N}={L}, --field-attribute={N}={L}  (\u7528\u6237\u5B9A\u4E49\u7684\u5C5E\u6027)",
                "  -M{N}={L}, --method-attribute={N}={L} (\u7528\u6237\u5B9A\u4E49\u7684\u5C5E\u6027)",
                "  -D{N}={L}, --code-attribute={N}={L}   (\u7528\u6237\u5B9A\u4E49\u7684\u5C5E\u6027)",
                "  -f{F}, --config-file={F}        \u8BFB\u53D6\u6587\u4EF6 F \u7684 Pack200.Packer \u5C5E\u6027",
                "  -v, --verbose                   \u63D0\u9AD8\u7A0B\u5E8F\u8BE6\u7EC6\u7A0B\u5EA6",
                "  -q, --quiet                     \u5C06\u8BE6\u7EC6\u7A0B\u5EA6\u8BBE\u7F6E\u4E3A\u6700\u4F4E\u7EA7\u522B",
                "  -l{F}, --log-file={F}           \u8F93\u51FA\u5230\u7ED9\u5B9A\u65E5\u5FD7\u6587\u4EF6, ",
                "                                  \u6216\u5BF9\u4E8E System.out \u6307\u5B9A '-'",
                "  -?, -h, --help                  \u8F93\u51FA\u6B64\u5E2E\u52A9\u6D88\u606F",
                "  -V, --version                   \u8F93\u51FA\u7A0B\u5E8F\u7248\u672C",
                "  -J{X}                           \u5C06\u9009\u9879 X \u4F20\u9012\u7ED9\u57FA\u7840 Java VM",
                "",
                "\u6CE8:",
                "  -P, -C, -F, -M \u548C -D \u9009\u9879\u7D2F\u8BA1\u3002",
                "  \u793A\u4F8B\u5C5E\u6027\u5B9A\u4E49:  -C SourceFile=RUH\u3002",
                "  Config. \u6587\u4EF6\u5C5E\u6027\u7531 Pack200 API \u5B9A\u4E49\u3002",
                "  \u6709\u5173 -S, -E, -H-, -m, -U \u503C\u7684\u542B\u4E49, \u8BF7\u53C2\u9605 Pack200 API\u3002",
                "  \u5E03\u5C40\u5B9A\u4E49 (\u4F8B\u5982 RUH) \u7531 JSR 200 \u5B9A\u4E49\u3002",
                "",
                "\u91CD\u65B0\u6253\u5305\u6A21\u5F0F\u901A\u8FC7\u6253\u5305/\u89E3\u5305\u5468\u671F\u66F4\u65B0 JAR \u6587\u4EF6:",
                "    pack200 [-r|--repack] [-opt | --option=value]... [repackedy.jar] y.jar\n",
                "",
                "\u9000\u51FA\u72B6\u6001:",
                "  \u5982\u679C\u6210\u529F\u5219\u4E3A 0; \u5982\u679C\u51FA\u73B0\u9519\u8BEF, \u5219\u4E3A\u5927\u4E8E 0 \u7684\u503C"
            }
        },
        {UNPACK_HELP, new String[] {
                "\u7528\u6CD5:  unpack200 [-opt... | --option=value]... x.pack[.gz] y.jar\n",
                "",
                "\u89E3\u5305\u9009\u9879",
                "  -H{h}, --deflate-hint={h}     \u8986\u76D6\u5DF2\u4F20\u8F93\u7684\u538B\u7F29\u63D0\u793A:",
                "                                true, false \u6216 keep (\u9ED8\u8BA4\u503C)",
                "  -r, --remove-pack-file        \u89E3\u5305\u4E4B\u540E\u5220\u9664\u8F93\u5165\u6587\u4EF6",
                "  -v, --verbose                   \u63D0\u9AD8\u7A0B\u5E8F\u8BE6\u7EC6\u7A0B\u5EA6",
                "  -q, --quiet                     \u5C06\u8BE6\u7EC6\u7A0B\u5EA6\u8BBE\u7F6E\u4E3A\u6700\u4F4E\u7EA7\u522B",
                "  -l{F}, --log-file={F}         \u8F93\u51FA\u5230\u7ED9\u5B9A\u65E5\u5FD7\u6587\u4EF6, \u6216",
                "                                \u5BF9\u4E8E System.out \u6307\u5B9A '-'",
                "  -?, -h, --help                \u8F93\u51FA\u6B64\u5E2E\u52A9\u6D88\u606F",
                "  -V, --version                 \u8F93\u51FA\u7A0B\u5E8F\u7248\u672C",
                "  -J{X}                         \u5C06\u9009\u9879 X \u4F20\u9012\u7ED9\u57FA\u7840 Java VM"
            }
        },
        {MORE_INFO, "(\u6709\u5173\u8BE6\u7EC6\u4FE1\u606F, \u8BF7\u8FD0\u884C {0} --help\u3002)"}, // parameter 0:command name
        {DUPLICATE_OPTION, "\u91CD\u590D\u7684\u9009\u9879: {0}"}, // parameter 0:option
        {BAD_SPEC, "{0}\u7684\u89C4\u8303\u9519\u8BEF: {1}"}, // parameter 0:option;parameter 1:specifier
        {DEPRECATED, "\n\u8B66\u544A\uFF1A{0} \u5DE5\u5177\u5DF2\u8FC7\u65F6\uFF0C\u8BA1\u5212\u5728\u672A\u6765\u7684 JDK \u53D1\u884C\u7248\u4E2D\u5220\u9664\u3002\n"} // parameter 0:command name
    };

    protected Object[][] getContents() {
        return resource;
    }
}
